/**
 * Competency picker from user plans.
 *
 * To handle 'save' events use: picker.on('save').
 *
 * This will receive a object with either a single 'competencyId', or an array in 'competencyIds'
 * depending on the value of multiSelect.
 *
 * @module     tool_lp/competencypicker_user_plans
 * @copyright  2015 Frédéric Massart - FMCorz.net
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/competencypicker_user_plans",["jquery","core/notification","core/ajax","core/templates","core/str","tool_lp/tree","tool_lp/competencypicker"],(function($,Notification,Ajax,Templates,Str,Tree,PickerBase){var Picker=function(userId,singlePlan,multiSelect){PickerBase.prototype.constructor.apply(this,[1,!1,"self",multiSelect]),this._userId=userId,this._plans=[],singlePlan&&(this._planId=singlePlan,this._singlePlan=!0)};return(Picker.prototype=Object.create(PickerBase.prototype))._plans=null,Picker.prototype._planId=null,Picker.prototype._singlePlan=!1,Picker.prototype._userId=null,Picker.prototype._afterRender=function(){var self=this;PickerBase.prototype._afterRender.apply(self,arguments),self._singlePlan||self._find('[data-action="chooseplan"]').change((function(e){self._planId=$(e.target).val(),self._loadCompetencies().then(self._refresh.bind(self)).catch(Notification.exception)}))},Picker.prototype._fetchCompetencies=function(planId,searchText){var self=this;return Ajax.call([{methodname:"core_competency_list_plan_competencies",args:{id:planId}}])[0].done((function(competencies){var i,comp,tree=[];for(i=0;i<competencies.length;i++)(comp=competencies[i].competency).shortname.toLowerCase().indexOf(searchText.toLowerCase())<0||(comp.children=[],comp.haschildren=0,tree.push(comp));self._competencies=tree})).fail(Notification.exception)},Picker.prototype._getPlan=function(id){var plan;return $.each(this._plans,(function(i,f){f.id!=id||(plan=f)})),plan},Picker.prototype._loadCompetencies=function(){return this._fetchCompetencies(this._planId,this._searchText)},Picker.prototype._loadPlans=function(){var self=this;return self._plans.length>0?$.when():(self._singlePlan?Ajax.call([{methodname:"core_competency_read_plan",args:{id:this._planId}}])[0].then((function(plan){return[plan]})):Ajax.call([{methodname:"core_competency_list_user_plans",args:{userid:self._userId}}])[0]).done((function(plans){self._plans=plans})).fail(Notification.exception)},Picker.prototype._preRender=function(){var self=this;return self._loadPlans().then((function(){return!self._planId&&self._plans.length>0&&(self._planId=self._plans[0].id),self._planId?self._loadCompetencies():(self._plans=[],$.when())}))},Picker.prototype._render=function(){var self=this;return self._preRender().then((function(){self._singlePlan||$.each(self._plans,(function(i,plan){plan.id==self._planId?plan.selected=!0:plan.selected=!1}));var context={competencies:self._competencies,plan:self._getPlan(self._planId),plans:self._plans,search:self._searchText,singlePlan:self._singlePlan};return Templates.render("tool_lp/competency_picker_user_plans",context)}))},Picker}));

//# sourceMappingURL=competencypicker_user_plans.min.js.map