<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains the forms to create and edit an instance of this module
 *
 * @package mod_imscp
 * @copyright  2009 Petr Skoda  {@link http://skodak.org}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/course/moodleform_mod.php');
require_once($CFG->libdir.'/filelib.php');

/**
 * IMS CP configuration form
 *
 * @package mod_imscp
 * @copyright  2009 Petr Skoda  {@link http://skodak.org}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class mod_imscp_mod_form extends moodleform_mod {
    /**
     * Define the form - called by parent constructor
     */
    public function definition() {
        global $CFG, $DB;
        $mform = $this->_form;

        $config = get_config('imscp');

        // Title and description.
        $mform->addElement('header', 'general', get_string('general', 'form'));
        $mform->addElement('text', 'name', get_string('name'), array('size' => '48'));
        if (!empty($CFG->formatstringstriptags)) {
            $mform->setType('name', PARAM_TEXT);
        } else {
            $mform->setType('name', PARAM_CLEANHTML);
        }
        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');
        $this->standard_intro_elements();

        // IMS-CP file upload.
        $mform->addElement('header', 'content', get_string('contentheader', 'imscp'));
        $mform->setExpanded('content', true);

        $mform->addElement('filepicker', 'package', get_string('packagefile', 'imscp'), null,
            ['accepted_types' => ['application/zip', '.imscc']]);

        $options = array('-1' => get_string('all'), '0' => get_string('no'),
                         '1' => '1', '2' => '2', '5' => '5', '10' => '10', '20' => '20');
        $mform->addElement('select', 'keepold', get_string('keepold', 'imscp'), $options);
        $mform->setDefault('keepold', $config->keepold);
        $mform->setAdvanced('keepold', $config->keepold_adv);

        $this->standard_coursemodule_elements();

        $this->add_action_buttons();
    }

    /**
     * Perform minimal validation on the settings form
     * @param array $data
     * @param array $files
     */
    public function validation($data, $files) {
        if ($errors = parent::validation($data, $files)) {
            return $errors;
        }

        if (!$this->get_draft_files('package')) {
            if (!$this->current->instance) {
                $errors['package'] = get_string('required');
                return $errors;
            }
        }

        return $errors;
    }
}
